/*
 * Decompiled with CFR 0.152.
 */
package com.sothawo.mapjfx;

import com.sothawo.mapjfx.Coordinate;
import com.sothawo.mapjfx.MapCoordinateElement;
import com.sothawo.mapjfx.MapLabel;
import java.net.URL;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import javafx.beans.value.ObservableValue;

public final class Marker
extends MapCoordinateElement {
    private static final AtomicLong nextId = new AtomicLong(1L);
    private final String id;
    private final URL imageURL;
    private Optional<MapLabel> optMapLabel = Optional.empty();

    public static Marker createProvided(Provided provided) {
        Objects.requireNonNull(provided);
        return new Marker(Marker.class.getResource("/markers/" + provided.getFilename()), provided.getOffsetX(), provided.getOffsetY());
    }

    public Marker(URL imageURL) {
        this(imageURL, 0, 0);
    }

    public Marker(URL imageURL, int offsetX, int offsetY) {
        super(offsetX, offsetY);
        this.id = "marker-" + nextId.getAndIncrement();
        this.imageURL = Objects.requireNonNull(imageURL);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public URL getImageURL() {
        return this.imageURL;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Marker marker = (Marker)o;
        return this.id.equals(marker.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public String toString() {
        return "Marker{id='" + this.id + '\'' + ", imageURL=" + this.imageURL + "} " + super.toString();
    }

    public Marker attachLabel(MapLabel mapLabel) {
        this.optMapLabel = Optional.of(Objects.requireNonNull(mapLabel));
        mapLabel.setMarker(this);
        mapLabel.visibleProperty().bind((ObservableValue)this.visibleProperty());
        mapLabel.positionProperty().bind(this.positionProperty());
        return this;
    }

    public Marker detachLabel() {
        this.optMapLabel.ifPresent(mapLabel -> {
            mapLabel.setMarker(null);
            mapLabel.visibleProperty().unbind();
            mapLabel.positionProperty().unbind();
        });
        this.optMapLabel = Optional.empty();
        return this;
    }

    public Optional<MapLabel> getMapLabel() {
        return this.optMapLabel;
    }

    @Override
    public Marker setPosition(Coordinate position) {
        return (Marker)super.setPosition(position);
    }

    @Override
    public Marker setVisible(boolean visible) {
        return (Marker)super.setVisible(visible);
    }

    public static enum Provided {
        BLUE("blue_map_marker.png", -32, -64),
        GREEN("green_map_marker.png", -32, -64),
        ORANGE("orange_map_marker.png", -32, -64),
        RED("red_map_marker.png", -32, -64);

        private final String filename;
        private final int offsetX;
        private final int offsetY;

        private Provided(String filename, int offsetX, int offsetY) {
            this.filename = filename;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
        }

        public String getFilename() {
            return this.filename;
        }

        public int getOffsetX() {
            return this.offsetX;
        }

        public int getOffsetY() {
            return this.offsetY;
        }
    }
}

